unit SIMD_Import;

interface

type
	TSSEHandle	= pointer;

   TSingleArray	= array [0..1024] of single;
   PSingleArray	= ^TSingleArray;

function SSE_CreateVector(Count:integer;Data:PSingleArray):TSSEHandle; stdcall; external 'SIMD.DLL';
procedure SSE_FreeVector(aHandle:TSSEHandle); stdcall; external 'SIMD.DLL';
function SSE_VectorData(aHandle:TSSEHandle;var Count:integer):PSingleArray stdcall; external 'SIMD.DLL';
function SSE_AddVector(Source,V:TSSEHandle):integer; stdcall; external 'SIMD.DLL';
function SSE_SubtractVector(Source,V:TSSEHandle):integer; stdcall; external 'SIMD.DLL';
function SSE_MultiplyVector(Source,V:TSSEHandle):integer; stdcall; external 'SIMD.DLL';
function SSE_DivideVector(Source,V:TSSEHandle):integer; stdcall; external 'SIMD.DLL';
function SSE_AddSquare(Source,V:TSSEHandle):integer; stdcall; external 'SIMD.DLL';   // Source = Source + V^2
function SSE_InnerSum(Source:TSSEHandle;var Res:single):integer; stdcall; external 'SIMD.DLL';  // Result = Sum(Source[i])
function SSE_InnerSumAbs(Source:TSSEHandle;var Res:single):integer; stdcall; external 'SIMD.DLL';  // Result = Sum(abs(Source[i]))
function SSE_DotProduct(Source,V:TSSEHandle;var Res:single):integer; stdcall; external 'SIMD.DLL';  // Result = Sum(Source[i] * V[i])
function SSE_SqrVector(Source,V:TSSEHandle):integer; stdcall; external 'SIMD.DLL';  // Source = Sqr(V)
function SSE_MaxValue(Source:TSSEHandle;var Res:single):integer; stdcall; external 'SIMD.DLL';  // Result = Max(Source[i])
function SSE_MaxAbsValue(Source:TSSEHandle;var Res:single):integer; stdcall; external 'SIMD.DLL';  // Result = Max(abs(Source[i]))
function SSE_IndexMaxValue(Source:TSSEHandle;var Res:integer):integer; stdcall; external 'SIMD.DLL';  // Result = index of Max(Source)
function SSE_MinValue(Source:TSSEHandle;var Res:single):integer; stdcall; external 'SIMD.DLL';  // Result = Min(Source[i])
function SSE_MinAbsValue(Source:TSSEHandle;var Res:single):integer; stdcall; external 'SIMD.DLL';  // Result = Min(abs(Source[i]))
function SSE_IndexMinValue(Source:TSSEHandle;var Res:integer):integer; stdcall; external 'SIMD.DLL';  // Result = index of Min(Source)
function SSE_MeanValue(Source:TSSEHandle;var Res:single):integer; stdcall; external 'SIMD.DLL';  // Result = Sum(Source[i]) / NumElements
function SSE_Scale(Source:TSSEHandle;Factor:single):integer; stdcall; external 'SIMD.DLL';  // Source = value * Source
function SSE_DualAdd(Source,V1,V2:TSSEHandle):integer; stdcall; external 'SIMD.DLL';  // Source := V1 + V2
function SSE_DualAddEx(Source,V1,V2:TSSEHandle;const xStartInd,xCount:integer):integer; stdcall; external 'SIMD.DLL';  // Source = V1 + V2; applies for elements [StartInd] ... [StartInd + Count -1]
function SSE_DualSub(Source,V1,V2:TSSEHandle):integer; stdcall; external 'SIMD.DLL';  // Source := V1 - V2
function SSE_DualSubEx(Source,V1,V2:TSSEHandle;const xStartInd,xCount:integer):integer; stdcall; external 'SIMD.DLL';
function SSE_DualMul(Source,V1,V2:TSSEHandle):integer; stdcall; external 'SIMD.DLL';  // Source := V1*V2
function SSE_DualMulEx(Source,V1,V2:TSSEHandle;const xStartInd,xCount:integer):integer; stdcall; external 'SIMD.DLL';
function SSE_DualDivide(Source,V1,V2:TSSEHandle):integer; stdcall; external 'SIMD.DLL'; // Source := V1/V2
function SSE_DualDivideEx(Source,V1,V2:TSSEHandle;const xStartInd,xCount:integer):integer; stdcall; external 'SIMD.DLL';
function SSE_DualMulDiv(Source,V1,V2:TSSEHandle):integer; stdcall; external 'SIMD.DLL';  // Source = Source*V1 / V2
function SSE_DualAddSquare(Source,V1,V2:TSSEHandle):integer; stdcall; external 'SIMD.DLL';   // Source = V1^2 + V2^2
function SSE_DualAddSquareEx(Source,V1,V2:TSSEHandle;const xStartInd,xCount:integer):integer; stdcall; external 'SIMD.DLL';
function SSE_DualMax(Source,V1,V2:TSSEHandle):integer; stdcall; external 'SIMD.DLL';  // Source = Max(Source, V)
function SSE_DualMaxEx(Source,V1,V2:TSSEHandle;const xStartInd,xCount:integer):integer; stdcall; external 'SIMD.DLL';  // Source = Max(Source, V)
function SSE_DualMin(Source,V1,V2:TSSEHandle):integer; stdcall; external 'SIMD.DLL';  // Source = Min(V1, V2)
function SSE_DualMinEx(Source,V1,V2:TSSEHandle;const xStartInd,xCount:integer):integer; stdcall; external 'SIMD.DLL';  // Source = Min(V1, V2)
function SSE_Add(Source:TSSEHandle;Value:single):integer; stdcall; external 'SIMD.DLL'; // Source = Source + value
function SSE_DualCombine(Source,V1,V2:TSSEHandle;xA,xB:single):integer; stdcall; external 'SIMD.DLL'; // Source := A*V1 + B*V2
function SSE_CombineVector(Source,V:TSSEHandle;xA:single):integer; stdcall; external 'SIMD.DLL'; // Source := Source + A*V1
function SSE_LerpVector(Source,V:TSSEHandle;xT:single):integer; stdcall; external 'SIMD.DLL';       // Source := Source + (V - Source) * t;
function SSE_DualLerp(Source,V1,V2:TSSEHandle;xT:single):integer; stdcall; external 'SIMD.DLL';       // Source := V1 + (V2 - V1) * t;
function SSE_InnerSqrSum(Source:TSSEHandle;var Res:single):integer; stdcall; external 'SIMD.DLL';  // Result = Sum(sqr(Source[i]))
function SSE_NormL1(Source,V:TSSEHandle;var Res:single):integer; stdcall; external 'SIMD.DLL'; // Result = Sum(abs(Source[i] - V[i])
function SSE_NormL2(Source,V:TSSEHandle;var Res:single):integer; stdcall; external 'SIMD.DLL'; // Result = Sun(sqr(Source[i] - V[i]);


implementation

end.
 
